<?php
session_start();

// Redirect jika belum login atau jika bukan admin yang login
if (!isset($_SESSION['logged_in']) || !$_SESSION['logged_in']) {
    header('Location: ');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_limit = intval($_POST['limit']);

    if ($new_limit > 0) {
        $config_content = "<?php return ['max_emails' => $new_limit]; ?>";
        file_put_contents('../kezy/config.php', $config_content);
        $success = "Konfigurasi berhasil diperbarui.";
    } else {
        $error = "Nilai batas tidak valid.";
    }
}

// Load configuration from config.php
$config = include '../kezy/config.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Konfigurasi Admin</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f0f0f0;
            padding: 20px;
        }

        .container {
            max-width: 600px;
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            margin: auto;
        }

        h1 {
            color: #333;
        }

        form {
            margin-top: 20px;
        }

        label {
            font-weight: bold;
            color: #555;
        }

        input[type="number"] {
            width: 100%;
            padding: 8px;
            margin-top: 8px;
            margin-bottom: 20px;
            border: 1px solid #ddd;
            border-radius: 4px;
        }

        button {
            background-color: #007BFF;
            color: white;
            border: none;
            padding: 10px 15px;
            border-radius: 4px;
            cursor: pointer;
            margin-top: 10px;
            display: block;
            width: 100%;
        }

        button:hover {
            background-color: #0056b3;
        }

        .message {
            margin-top: 20px;
            padding: 10px;
            border-radius: 4px;
            text-align: center;
        }

        .success {
            background-color: #d4edda;
            color: #155724;
        }

        .error {
            background-color: #f8d7da;
            color: #721c24;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Konfigurasi Admin</h1>
        <form method="POST">
            <label for="limit">Atur batas maksimum email:</label>
            <input type="number" id="limit" name="limit" value="<?php echo $config['max_emails']; ?>" required>
            <button type="submit">Perbarui</button>
            <?php if (isset($success)): ?>
                <div class="message success"><?php echo $success; ?></div>
            <?php endif; ?>
            <?php if (isset($error)): ?>
                <div class="message error"><?php echo $error; ?></div>
            <?php endif; ?>
        </form>
    </div>
</body>
</html>
